#define silnikLewy 2
#define silnikPrawy 4
#include <SPI.h>
#include <printf.h>
#include "nRF24L01.h"
#include "RF24.h"

RF24 radio(7,8);
const uint64_t pipes[2] = {0xF0F0F0F0E1LL, 0xF0F0F0F0D2LL};

struct paczuszka{
  byte prawy_y;
  byte prawy_x;
  byte lewy_y;
  byte lewy_x;
  byte pstryczek_lewy;
  byte pstryczek_prawy;
};
paczuszka info;

void setup() {
    pinMode(22, INPUT_PULLUP);
    pinMode(23, INPUT_PULLUP);
    pinMode(silnikPrawy, OUTPUT);
    pinMode(silnikLewy, OUTPUT);
    Serial.begin(57600);
    radio.begin();
    printf_begin();
    radio.setRetries(15,15);
    radio.openReadingPipe(1,pipes[1]);
    radio.startListening();
    radio.printDetails();
    radio.openWritingPipe(pipes[0]);
    radio.openReadingPipe(1,pipes[1]);
    radio.stopListening();
    info.prawy_y=0;
    info.prawy_x=0;
    info.lewy_y=0;
    info.lewy_x=0;
    info.pstryczek_lewy=0;
    info.pstryczek_prawy=0;
}
void loop() {
    radio.stopListening();
    radio.openWritingPipe(pipes[0]);
    info.prawy_y=map(analogRead(A0), 0, 1023, 0, 255);
    if(info.prawy_y<40){
      info.prawy_y=0;
    }
    if(info.prawy_y>225){
      info.prawy_y=255;
    }
    info.lewy_y=map(analogRead(A1), 0, 1023, 0, 255);
    if(info.lewy_y<40){
      info.lewy_y=0;
    }
    if(info.lewy_y>225){
      info.lewy_y=255;
    }
    info.prawy_x=map(analogRead(A2), 0, 1023, 0, 255);
    info.lewy_x=map(analogRead(A3), 0, 1023, 0, 255);
    if(digitalRead(22)==HIGH) info.pstryczek_lewy=1;
    else info.pstryczek_lewy =0;
    if(digitalRead(23)==HIGH) info.pstryczek_prawy=1;
    else info.pstryczek_prawy =0;
    radio.write( &info, sizeof(paczuszka));

}
